// This program can act as an interval timer on pin "Digital_Input_Pin".
// The program is interrupt driven. A hardware interrupt is generated on
// a low-to-high transition on digital input pin "Digital_Input_Pin".
// The interrupt service routine "Send_Interval()" sends the elapsed time
// with respect to the previous transition as a decimal string over the
// serial bus. This is done with a 4us resolution.
//
//                                            Geert Langereis, October 2010

const int Baudrate = 19200;
const int Digital_Input_Pin = 2;    // the pin that has INT0 functionality

void setup()
{
  Serial.begin(Baudrate);           // For sending data to the computer
  pinMode(Digital_Input_Pin, INPUT);
  attachInterrupt(0, Send_Interval, RISING);  // Attach to INT0. 
}

void loop() {
  // nothing to do, its all in the interrupt handlers!
}  

unsigned long LastTime, NewTime, j;
void Send_Interval()
{ 
  NewTime = micros(); // Resolution 4us, only one overrun (=error) in 70 minutes
  Serial.println(NewTime-LastTime, DEC); 
  LastTime = NewTime;
}
